<%@include file="/jsp/init.jsp" %>

<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<style>
	.sectionHeading{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.section{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.summaryTable table, th, td{
	    border: thin solid #d9d9d9;
	    border-collapse: collapse;
	    margin: 12px;
	    padding: 5px;
	    text-align: center;
	}
	.summaryTable tr:hover {
		background-color: #f5f5f5;
	}
	.summaryTable th {
	    background-color: #f0efef;
	}
	.manage-layout-td text{
		/* width: 840px; */
		width: 67px;
		padding-left: 10px;
	}
	.manage-layout-td textarea{
		/* width: 840px; */
		width: 767px;
		padding-left: 10px;
	}

	.messageicon{
	margin-left:50px;font-size: 15px; font-weight:100; float:center;
	}

	.assessment-history-all, .ongoing-assmt-history-all, .ongoing-assmt-all{
		float:right;
		margin:10px;
	}
	.section-link{
		float:right;
		margin:10px;
	}
	
</style>	
 	
	<c:set var="form_" value="${caretMap_['form_']}" />
 	
 	<c:set var="vcg" value="${form_['vcg']}" />
 	
	<c:set var="editAction" value="edit-vcg-entry icon-pencil" />
	<c:set var="auditLog" value="audit-vcg-entry icon-time" />
	<c:set var="title" value="click-to-begin-changes" />
	<c:set var="message" value="edit-vcg" />
	

 	<c:set var="veteranId" value="${form_['veteranId']}" />
 	<c:set var="primaryValidAppDate" value="${form_['primaryValidAppDate']}" />
 	<c:set var="secondaryValidAppDate" value="${form_['secondaryValidAppDate']}" />
 	<c:set var="secondaryTwoValidAppDate" value="${form_['secondaryTwoValidAppDate']}" />
 	<c:set var="primaryApplicationId" value="${form_['primaryApplicationId']}" />
 	<c:set var="secondaryApplicationId" value="${form_['secondaryApplicationId']}" />
 	<c:set var="secondaryTwoApplicationId" value="${form_['secondaryTwoApplicationId']}" />	

 	<c:set var="primaryApprovalDate" value="${form_['primaryApprovalDate']}" />	
	
<!--
<div class="menu-wrapper">
<aui:nav cssClass="menu-field">
     <aui:nav-item href="javascript:" iconCssClass="icon-plus" label="new-assessment" id="scheduleAssessment" >
     </aui:nav-item>
</aui:nav>
</div>	
-->
	
<fieldset id="sectionCollapse">
<div class="vcg-record">

	<div class="next-section-label section-header">
		<div class="icon-group show-tooltip" title='<liferay-ui:message key="click-to-toggle-pane" />' > 
			<liferay-ui:message key="vcg-record" />
		</div>
	</div>
	<hr/>

	
	<liferay-ui:icon-menu cssClass="messageicon">
	<liferay-ui:icon image="message" message="internal_message" url="javascript:composeVCG(${vcg.vcgId});"  />
	</liferay-ui:icon-menu>
	<!-- <legend>VCG Record</legend> -->
		
	<div class="content toggler-content-${showSection}">

	<div class="vcg-entry-menu" id="${vcg.vcgId}">
			<div>
				<div class="float-right">
					<a class="btn-link ${auditLog} btn-primary" title="<liferay-ui:message key="vcg-audit-log-all-tooltip" />" >&nbsp;<liferay-ui:message key="vcg-entry-log-all" /></a>
				</div>
			</div>
	</div>

	<div class="select-caregiver" >
		<div class="person-selection vcg-entry-menu" id="${vcg.veteran.primaryKey}">
			<div>
				<div class="float-left">
					<c:if test="${form['EaE']}" >
						<a class="view-eligibility icon-info-sign btn-link btn-primary" title='<liferay-ui:message key="view-eligibility-tooltip" />'  >&nbsp;E&amp;E</a>
					</c:if>
					<a class="btn-link ${editAction} btn-primary" title="<liferay-ui:message key="${title}" />" >&nbsp;<liferay-ui:message key="edit-vcg-veteran" /></a>
				</div>
				<div class="float-right">
					<a class="btn-link ${auditLog} btn-primary" title="<liferay-ui:message key="vcg-person-audit-log-tooltip" />" >&nbsp;<liferay-ui:message key="vcg-entry-log" /></a>
				</div>
			</div>
			<hr/>
			<div class="center-position">
				<div class="care-giver-name" id="update_veteran">
					<c:if test="${! empty vcg.veteran}">
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
				    	 			<div class="srow-label">
				    	 			Veteran Name:</div>${vcg.veteran.lastName}, ${vcg.veteran.firstName} ${vcg.veteran.middleName}
				    	 			<!-- <div class="edit-identity icon-user btn mini" title='<liferay-ui:message key="user-verified-${vcg.veteran.verifiedIdentity}-tooltip" />'  >&nbsp;</div>-->
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">Facility:</div>${vcg.veteran.facilityName} 
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">SSN:</div>${vcg.veteran.ssn}
				    			</div>
				    			<hr/>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Gender:</div><liferay-ui:message key="${vcg.veteran.gender}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">ICN:</div>${vcg.veteran.icn}
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<fmt:formatDate value="${vcg.veteran.birthDate}" var="vbday" type="date" pattern="MM/dd/yyyy"/>
				    	 			<div class="lrow-label">DOB:</div>${vbday}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">VA Health Enrolled:</div><liferay-ui:message key="${vcg.veteran.vaHealthEnrolled}-yes" />
				    			</div>
				    			<hr/>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">Address:</div>${vcg.veteran.address}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">&nbsp;&nbsp;
				    					<c:choose>
				    						<c:when test="${vcg.veteran.validUspsAddress}">
						    					<div class="icon-star upper-icon-padding" title="<liferay-ui:message key='usps-validated'/>"></div>
				    						</c:when>
				    						<c:otherwise>
												<div class="icon-flag upper-icon-padding" title="<liferay-ui:message key='non-usps-validated'/>"></div>
				    						</c:otherwise>
				    					</c:choose>
									&nbsp;&nbsp;</div>${vcg.veteran.city}, ${vcg.veteran.state} ${vcg.veteran.zip}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Email:</div>${vcg.veteran.email}  
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Phone:</div>${vcg.veteran.phone}  ${vcg.veteran.phone2} 
				    			</div>
				    		</div>
			    		</div>
		    		</c:if>
				</div>
			</div>
		</div>
	</div>
	
	
					<c:if test="${! empty vcg.primary}">
	<div class="select-caregiver" >
		<div class="person-selection vcg-entry-menu" id="${vcg.primary.primaryKey}" >
			<div>
				<div class="float-left">
					<a class="btn-link ${editAction} btn-primary" title="<liferay-ui:message key="${title}" />" >&nbsp;
						<liferay-ui:message key="edit-vcg-primary" />
					</a>
				</div>
				<div class="float-right">
					<a class="btn-link ${auditLog} btn-primary" title="<liferay-ui:message key="vcg-person-audit-log-tooltip" />"  >&nbsp;<liferay-ui:message key="vcg-entry-log" /></a>
				</div>
			</div>
			<hr/>
			<div class="center-position">
				<div class="care-giver-name" id="update_primary">
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
				    	 			<div class="srow-label">Primary Name:</div>${vcg.primary.lastName}, ${vcg.primary.firstName} ${vcg.primary.middleName} &nbsp;
				    	 			<c:if test="${!vcg.primary.verifiedIdentity}" >
				    	 				<c:set var="primBtn" value="btn"/>
				    	 			</c:if>
				    			</div>
				    			<div class="selected-vcg-row">
				    				<fmt:formatDate value="${vcg.tierEffectiveDate}" var="tierEffectiveDate" type="date" pattern="MM/dd/yyyy"/>
				    	 			<div class="srow-label">
				    	 			<c:if test="${vcg.tierEditEnabled}" >
				    	 				<div class="edit-tier icon-dollar btn mini" title='<liferay-ui:message key="tier-tooltip"/>' >&nbsp;</div>
				    	 			</c:if>
				    	 			Tier:</div><liferay-ui:message key="tier-level-${vcg.tierLevel}" />&nbsp; ${tierEffectiveDate} &nbsp;&nbsp;
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">
				    	 		  <c:choose> 
				    	 			<c:when test="${! empty vcg.primaryDispChoices}" >
				    	 				<c:set var="dispReason">
				    	 				  <c:choose>
				    						<c:when test="${fn:startsWith(vcg.primaryDispReason, 'revoked')}">revoked-caregiver</c:when>
				    						<c:otherwise>${vcg.primaryDispReason}</c:otherwise>
				    					  </c:choose>
				    					 </c:set>
				    	 				<div class="edit-disposition icon-legal btn mini" title='<liferay-ui:message key="${dispReason}-tooltip" />'  >&nbsp;</div>
				    	 			</c:when>
				    	 		  </c:choose>
				    	 			Status:</div><liferay-ui:message key="${vcg.primaryDispReason}" />&nbsp;&nbsp;
				    			</div>
				    			<c:if test="${vcg.vacoWaiverPrimary && !empty vcg.waiverPrimaryWork}">
				    			
				    				<c:choose> 
				    	 			<c:when test="${! empty vcg.waiverPrimaryWorkExpires && vcg.primaryDispReason eq 'IN_PROCESS'}" >
				    	 				<div class="delay-submitted selected-vcg-row" >
				    	 					VISN Application Delay processed, open until ${vcg.waiverPrimaryWorkExpires}
				    	 				</div>
				    	 			</c:when>
				    				<c:when test="${empty vcg.waiverPrimaryWorkExpires && vcg.primaryDispReason eq 'IN_PROCESS'}" >
				    					<div class="delay-submitted selected-vcg-row" >
				    	 					VISN Application Delay Review Submitted
				    	 				</div>
									</c:when>
				    	 		  </c:choose>
				    	 				
				    	 		</c:if>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">SSN:</div> ${vcg.primary.ssn} 
				    			</div>
				    			<hr/>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Relationship to Veteran:</div><liferay-ui:message key="${vcg.primaryType}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Gender:</div> <liferay-ui:message key="${vcg.primary.gender}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">ICN:</div>${vcg.primary.icn}
				    			</div>
				    			<div class="selected-vcg-row">
				    			<fmt:formatDate value="${vcg.primary.birthDate}" var="pbday" type="date" pattern="MM/dd/yyyy"/>
				    	 			<div class="lrow-label">DOB:</div> ${pbday}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Medicare Enrolled:</div> <liferay-ui:message key="${vcg.primary.mediEnrolled}-yes" />
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Other Insurance:</div> ${vcg.primary.otherHealthInsurance}
				    			</div>
				    			<hr/>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">Address:</div>${vcg.primary.address}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">&nbsp;&nbsp;
				    					<c:choose>
				    						<c:when test="${vcg.primary.validUspsAddress}">
						    					<div class="icon-star upper-icon-padding" title="<liferay-ui:message key='usps-validated'/>"></div>
				    						</c:when>
				    						<c:otherwise>
												<div class="icon-flag upper-icon-padding" title="<liferay-ui:message key='non-usps-validated'/>"></div>
				    						</c:otherwise>
				    					</c:choose>
									&nbsp;&nbsp;</div>${vcg.primary.city}, ${vcg.primary.state} ${vcg.primary.zip}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Email:</div>${vcg.primary.email}  
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Phone:</div>${vcg.primary.phone}  ${vcg.primary.phone2} 
				    			</div>
				    		</div>
			    		</div>
		    		
				</div>
			</div>
		</div>
	</div>
		    		</c:if>



					<c:if test="${! empty vcg.secondary}">
					
<div class="select-caregiver" >
		<div class="person-selection vcg-entry-menu" id="${vcg.secondary.primaryKey}" >
			<div>
				<div class="float-left">
					<a class="btn-link ${editAction} btn-primary" title='<liferay-ui:message key="${title}" />'  >&nbsp;<liferay-ui:message key="edit-vcg-secondary" /></a>
				</div>
				<div class="float-right">
					<a class="btn-link ${auditLog} btn-primary" title='<liferay-ui:message key="vcg-person-audit-log-tooltip" />' >&nbsp;<liferay-ui:message key="vcg-entry-log" /></a>
				</div>
			</div>
			<hr/>
			<div class="center-position">
				<div class="care-giver-name" id="update_secondary">
					
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
				    	 			<c:if test="${!vcg.secondary.verifiedIdentity}" >
				    	 				<c:set var="secBtn" value="btn"/>
				    	 			</c:if>
				    	 			<div class="srow-label">Secondary Name:</div>${vcg.secondary.lastName}, ${vcg.secondary.firstName} ${vcg.secondary.middleName} &nbsp;
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">
				    	 			<c:if test="${! empty vcg.secondaryDispChoices}" >
				    	 				<c:set var="dispReason">
				    	 				  <c:choose>
				    						<c:when test="${fn:startsWith(vcg.secondaryDispReason, 'revoked')}">revoked-caregiver</c:when>
				    						<c:otherwise>${vcg.secondaryDispReason}</c:otherwise>
				    					 </c:choose>
				    					 </c:set>
				    	 				<div class="edit-disposition icon-legal btn mini" title='<liferay-ui:message key="${dispReason}-tooltip" />'  >&nbsp;</div>
				    	 			</c:if>
				    	 			Status:</div><liferay-ui:message key="${vcg.secondaryDispReason}" />&nbsp;&nbsp;
				    			</div>
				    			<c:if test="${vcg.vacoWaiverSecondary && !empty vcg.waiverSecondaryWork}">
				    			
				    				<c:choose> 
				    	 			<c:when test="${! empty vcg.waiverSecondaryWorkExpires && vcg.secondaryDispReason eq 'IN_PROCESS'}" >
				    	 				<div class="delay-submitted selected-vcg-row" >
				    	 					VISN Application Delay Review Expires ${vcg.waiverSecondaryWorkExpires}
				    	 				</div>
				    	 			</c:when>
				    				<c:when test="${empty vcg.waiverSecondaryWorkExpires && vcg.secondaryDispReason eq 'IN_PROCESS'}" >
				    					<div class="delay-submitted selected-vcg-row" >
				    	 					VISN Application Delay Review Submitted
				    	 				</div>
									</c:when>
				    	 		  </c:choose>
				    	 				
				    	 		</c:if>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">SSN:</div> ${vcg.secondary.ssn}
				    			</div>
				    			<hr>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Relationship to Veteran:</div><liferay-ui:message key="${vcg.secondaryType}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Gender:</div> <liferay-ui:message key="${vcg.secondary.gender}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">ICN:</div> ${vcg.secondary.icn}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<fmt:formatDate value="${vcg.secondary.birthDate}" var="sbday" type="date" pattern="MM/dd/yyyy"/>
				    	 			<div class="lrow-label">DOB:</div> ${sbday}
				    			</div>
				    			<hr>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">Address:</div>${vcg.secondary.address}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">&nbsp;&nbsp;
				    					<c:choose>
				    						<c:when test="${vcg.secondary.validUspsAddress}">
						    					<div class="icon-star upper-icon-padding" title="<liferay-ui:message key='usps-validated'/>"></div>
				    						</c:when>
				    						<c:otherwise>
												<div class="icon-flag upper-icon-padding" title="<liferay-ui:message key='non-usps-validated'/>"></div>
				    						</c:otherwise>
				    					</c:choose>
									&nbsp;&nbsp;</div>${vcg.secondary.city}, ${vcg.secondary.state} ${vcg.secondary.zip}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Email:</div>${vcg.secondary.email}  
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Phone:</div>${vcg.secondary.phone}  ${vcg.secondary.phone2} 
				    			</div>
				    		</div>
			    		</div>
			    		
				</div>
			</div>
		</div>
	</div>
			    	</c:if>


					<c:if test="${! empty vcg.secondaryTwo}">
<div class="select-caregiver" >
		<div class="person-selection vcg-entry-menu" id="${vcg.secondaryTwo.primaryKey}" >
			<div>
				<div class="float-left">
					<a class="btn-link ${editAction} btn-primary" title='<liferay-ui:message key="${title}" />'  >&nbsp;<liferay-ui:message key="edit-vcg-secondaryTwo" /></a>
				</div>
				<div class="float-right">
					<a class="btn-link ${auditLog} btn-primary" title='<liferay-ui:message key="vcg-person-audit-log-tooltip" />'  >&nbsp;<liferay-ui:message key="vcg-entry-log" /></a>
				</div>
			</div>
			<hr/>
			<div class="center-position">
				<div class="care-giver-name" id="update_secondaryTwo">
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
				    	 			<div class="srow-label">Secondary II Name:</div>${vcg.secondaryTwo.lastName}, ${vcg.secondaryTwo.firstName} ${vcg.secondaryTwo.middleName} &nbsp;
				    	 			<c:if test="${!vcg.secondaryTwo.verifiedIdentity}" >
				    	 				<c:set var="secTwoBtn" value="btn"/>
				    	 			</c:if>
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">
				    	 			<c:if test="${! empty vcg.secondaryTwoDispChoices}" >
				    	 				<c:set var="dispReason">
				    	 				  <c:choose>
				    						<c:when test="${fn:startsWith(vcg.secondaryTwoDispReason, 'revoked')}">revoked-caregiver</c:when>
				    						<c:otherwise>${vcg.secondaryTwoDispReason}</c:otherwise>
				    					 </c:choose>
				    					 </c:set>
				    	 				<div class="edit-disposition icon-legal btn mini" title='<liferay-ui:message key="${dispReason}-tooltip" />'  >&nbsp;</div>
				    	 			</c:if>
				    	 			Status:</div><liferay-ui:message key="${vcg.secondaryTwoDispReason}" />&nbsp;&nbsp;
				    			</div>
				    			<c:if test="${vcg.vacoWaiverSecondaryTwo && !empty vcg.waiverSecondaryTwoWork}">
				    			
				    				<c:choose> 
				    	 			<c:when test="${! empty vcg.waiverSecondaryTwoWorkExpires && vcg.secondaryTwoDispReason eq 'IN_PROCESS'}" >
				    	 				<div class="delay-submitted selected-vcg-row" >
				    	 					VISN Application Delay Review Expires ${vcg.waiverSecondaryTwoWorkExpires}
				    	 				</div>
				    	 			</c:when>
				    				<c:when test="${empty vcg.waiverSecondaryTwoWorkExpires && vcg.secondaryTwoDispReason eq 'IN_PROCESS'}" >
				    					<div class="delay-submitted selected-vcg-row" >
				    	 					VISN Application Delay Review Submitted
				    	 				</div>
									</c:when>
				    	 		  </c:choose>
				    	 				
				    	 		</c:if>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">SSN:</div> ${vcg.secondaryTwo.ssn} 
				    			</div>
				    			<hr>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Relationship to Veteran:</div><liferay-ui:message key="${vcg.secondaryTwoType}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Gender:</div> <liferay-ui:message key="${vcg.secondaryTwo.gender}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">ICN:</div> ${vcg.secondaryTwo.icn}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<fmt:formatDate value="${vcg.secondaryTwo.birthDate}" var="s2bday" type="date" pattern="MM/dd/yyyy"/>
				    	 			<div class="lrow-label">DOB:</div> ${s2bday}
				    			</div>
				    			<hr>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">Address:</div>${vcg.secondaryTwo.address}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">&nbsp;&nbsp;
				    					<c:choose>
				    						<c:when test="${vcg.secondaryTwo.validUspsAddress}">
						    					<div class="icon-star upper-icon-padding" title="<liferay-ui:message key='usps-validated'/>"></div>
				    						</c:when>
				    						<c:otherwise>
												<div class="icon-flag upper-icon-padding" title="<liferay-ui:message key='non-usps-validated'/>"></div>
				    						</c:otherwise>
				    					</c:choose>
									&nbsp;&nbsp;</div>${vcg.secondaryTwo.city}, ${vcg.secondaryTwo.state} ${vcg.secondaryTwo.zip}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Email:</div>${vcg.secondaryTwo.email}  
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Phone:</div>${vcg.secondaryTwo.phone}  ${vcg.secondaryTwo.phone2} 
				    			</div>
				    		</div>
			    		</div>
				</div>
			</div>
		</div>
	</div>
			    	</c:if>
	
	<c:if test="${vcg.generalAssignable}">
		<c:set var="editAction" value="create-vcg-entry icon-user" />
		<c:set var="editVal">Assign</c:set>
		
		<c:set var="editGenAction" value="edit-vcg-entry icon-pencil" />
	</c:if>
	
<div class="select-caregiver" >
		<div class="person-selection vcg-entry-menu" id="${vcg.general.primaryKey}" >
			<div>
				<div class="float-left">
					<a class="btn-link ${editAction} btn-primary" title='<liferay-ui:message key="${title}" />'  >&nbsp;<liferay-ui:message key="edit${editVal}-vcg-general" /></a>
				</div>
				<div class="float-right">
					<a class="btn-link ${auditLog} btn-primary" title='<liferay-ui:message key="vcg-person-audit-log-tooltip" />'  >&nbsp;<liferay-ui:message key="vcg-entry-log" /></a>
				</div>
			</div>
			<hr/>
			<div class="center-position">
				<div class="care-giver-name" id="update_general">
	<c:if test="${! empty vcg.general}">
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
				    	 			
				    	 			<div class="srow-label">
				    	 			<c:if test="${!empty editGenAction}" >
					    	 			<div class="edit-vcg-entry icon-pencil btn mini" title='<liferay-ui:message key="edit-vcg-general" />'  >&nbsp;</div>
				    	 			</c:if>
				    	 			General Caregiver Name:</div>${vcg.general.lastName}, ${vcg.general.firstName} ${vcg.general.middleName} &nbsp;
				    	 			<c:if test="${!vcg.general.verifiedIdentity}" >
				    	 				<c:set var="genBtn" value="btn"/>
				    	 			</c:if>
				    	 			<!--
				    	 			<div class="edit-identity icon-user ${genBtn} mini" title='<liferay-ui:message key="user-verified-${vcg.general.verifiedIdentity}-tooltip" />'  >&nbsp;</div>
				    	 			-->
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">
				    	 			<c:if test="${! empty vcg.generalDispChoices}" >
				    	 				<c:set var="dispReason">
				    	 				  <c:choose>
				    						<c:when test="${fn:startsWith(vcg.generalDispReason, 'revoked')}">revoked-caregiver</c:when>
				    						<c:otherwise>${vcg.generalDispReason}</c:otherwise>
				    					  </c:choose>
				    					 </c:set>
				    	 				<div class="edit-disposition icon-legal btn mini" title='<liferay-ui:message key="${dispReason}-tooltip" />'  >&nbsp;</div>
				    	 			</c:if>
				    	 			Status:</div><liferay-ui:message key="${vcg.generalDispReason}" />&nbsp;&nbsp;
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">SSN:</div> ${vcg.general.ssn} 
				    			</div>
				    			<hr>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Relationship to Veteran:</div><liferay-ui:message key="${vcg.generalType}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">Gender:</div> <liferay-ui:message key="${vcg.general.gender}" />
				    			</div>
				    			<div class="selected-vcg-row">
				    	 			<div class="lrow-label">ICN:</div> ${vcg.general.icn}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<fmt:formatDate value="${vcg.general.birthDate}" var="s2bday" type="date" pattern="MM/dd/yyyy"/>
				    	 			<div class="lrow-label">DOB:</div> ${s2bday}
				    			</div>
				    			<hr>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">Address:</div>${vcg.general.address}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="arow-label">&nbsp;&nbsp;
				    					<c:choose>
				    						<c:when test="${vcg.general.validUspsAddress}">
						    					<div class="icon-star upper-icon-padding" title="<liferay-ui:message key='usps-validated'/>"></div>
				    						</c:when>
				    						<c:otherwise>
												<div class="icon-flag upper-icon-padding" title="<liferay-ui:message key='non-usps-validated'/>"></div>
				    						</c:otherwise>
				    					</c:choose>
									&nbsp;&nbsp;</div>${vcg.general.city}, ${vcg.general.state} ${vcg.general.zip}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Email:</div>${vcg.general.email}  
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="lrow-label">Phone:</div>${vcg.general.phone}  ${vcg.general.phone2} 
				    			</div>
				    		</div>
			    		</div>
			    	</c:if>
				</div>
			</div>
		</div>
	</div>
	
	
	
	
</div>	


<div class="supporting-docs">
	<div class="next-section-label section-header">
		<div class="icon-folder-open show-tooltip" title='<liferay-ui:message key="click-to-toggle-pane" />' > 
			<liferay-ui:message key="supporting-docs" />
		</div>
	</div>
	<div>
		<a class="btn-link section-link supporting-documents-all icon-time btn-primary" id="${vcg.vcgId}" title="<liferay-ui:message key="supporting-docs-all" />" >&nbsp;<liferay-ui:message key="supporting-docs-all" /></a>
	</div>
	<div>
		<a class="btn-link section-link supporting-documents-history icon-time btn-primary" id="${vcg.vcgId}" title="<liferay-ui:message key="supporting-docs-history" />" >&nbsp;<liferay-ui:message key="supporting-docs-history" /></a>
	</div>
	
	<hr/>
	<!-- <legend class="header">Supporting Documents</legend> -->

<div class="content toggler-content-expanded">	

	<div class="sectionHeading">Current Supporting Documents</div>		
	<div class="summaryTable">
		<table style="width:98%">
			<tr>
			  <th width="5%">Type</th> 
			  <th width="15%">File Name</th> 
			  <th width="5%">File Type</th>
			  <th width="5%">File Size</th> 	
			  <th width="10%">Creation Date</th>  
			   <th width="10%">Created By</th>  
			  <th width="5%">Primary</th> 
			  <th width="5%">Secondary</th>
			  <th width="5%">Secondary Two</th>
			  <th width="10%">Action</th>			  
			</tr>
			
		<c:if test="${form_['vcgDocsCurrentSize'] gt 0}">
			<c:forEach var="doc" items="${form_['vcgDocsCurrent']}">	
			<tr id="row_${doc.documId}">
			    <td>${doc.uiDocType}</td>
			    <td>${doc.name}</td>
			    <td>${doc.docType}</td>
			    <td>${doc.docSize}&nbsp;KB</td>
			    <td>${doc.creationDate}</td>
			    <td>${doc.createdByLastName} , ${doc.createdByFirstName}</td>
			    <td><c:if test="${doc.primary}"><div class="icon-ok"></div></c:if></td>
			    <td><c:if test="${doc.secondary}"><div class="icon-ok"></div></c:if></td>
			    <td><c:if test="${doc.secondaryTwo}"><div class="icon-ok"></div></c:if></td>
			    <td>
					<portlet:resourceURL var="getDocum">
						<portlet:param name="action" value="getDocum"/>
						<portlet:param name="documId" value="${doc.documId}"/>
					</portlet:resourceURL>
					<a href="${getDocum}" target="_blank" ><i class="close-window btn btn-primary" >&nbsp; View</i></a>
					<a class="btn-primary delete-document" id="${doc.documId}"><i class="close-window btn btn-primary" >&nbsp; Delete</i></a>			    	
				</td>
			</tr>
			</c:forEach>
		</c:if>
		<c:if test="${form_['vcgDocsCurrentSize'] eq 0}">
			<tr>
				<td colspan=10>No Current Documents because there are no In Process, Approved or Reinstated Caregivers</td>
			</tr>
		</c:if>
		
		</table>
	</div>
</div>	
</div>	


<div class="training-logs">
	<div class="next-section-label section-header">
		<div class=" icon-file show-tooltip" title='<liferay-ui:message key="click-to-toggle-pane" />' > 
			<liferay-ui:message key="training-logs" />
		</div>
	</div>
	<hr/>
	<!-- <legend class="header">Training Log</legend> -->
		
	<div class="content toggler-content-${showSection}">
		<div class="clear-both" id="<portlet:namespace/>trainingLog" ></div>
	</div>
</div>


<div class="initial-assessments">

	<div class="next-section-label section-header">
		<div class="icon-list show-tooltip" title='<liferay-ui:message key="click-to-toggle-pane" />' > 
			<liferay-ui:message key="assessments" />
		</div>
	</div>
	<div>
		<a class="btn-link assessment-history-all icon-time btn-primary" id="${vcg.vcgId}" title="<liferay-ui:message key="assmt-audit-log" />" >&nbsp;<liferay-ui:message key="assmt-audit-all" /></a>
	</div>
	
	<hr/>
	<!-- <legend class="header">Assessments/Training (Initial)</legend> -->
	
	<div class="content toggler-content-expanded">
		<c:if test="${vcg.primaryId gt 0 && (vcg.primaryDispReason eq 'IN_PROCESS' || vcg.primaryDispReason eq 'APPROVED' || vcg.primaryDispReason eq 'REINSTATED') }">
		<div class="sectionHeading">Primary Caregiver</div>		
		<div class="summaryTable">
		<table style="width:98%">
			<tr>
			  <td width="100%" colspan='5' style="text-align:left;">Valid Application Received Date - ${primaryValidAppDate}</td> 
			</tr>

			<tr>
			  <th width="30%">Assessment</th> 
			  <th width="10%">* Completion Date</th> 	  
			  <th width="30%">Comment/Note</th> 
			  <th width="15%">Action</th>
			  <th width="15%">History</th>			  
			</tr>
	
			<c:forEach var="oneAssessment" items="${form_['primaryAssessmentList']}" >	
			<c:set var="isDisabled" value="false"/>
			<!-- Disable when primary status id approved or reinstated, or assessment is already there -->
			<c:if test="${ vcg.primaryDispReason eq 'APPROVED' || vcg.primaryDispReason eq 'REINSTATED' || oneAssessment.assessment.assmtId gt 0}"><c:set var="isDisabled" value="true"/></c:if>
			<tr>
			    <td>
				    <input type="hidden" name="${oneAssessment.assessment.type}_caregiverId" value="${vcg.primaryId}" id="${oneAssessment.assessment.type}_caregiverId"/>
				    <input type="hidden" name="${oneAssessment.assessment.type}_assessmentId" value="${oneAssessment.assessment.assmtId}" id="${oneAssessment.assessment.type}_assessmentId"/>
				    <liferay-ui:message key="${oneAssessment.assessment.type}_ui" />
				</td>
			    <td>
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass['comletionDate']}"  >
						<aui:input label="" name="${oneAssessment.assessment.type}_completionDate" value="${oneAssessment.formattedcompletionDate}" cssClass="date-field" type="text" id="${oneAssessment.assessment.type}_completionDate" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			  		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass}"  >
				 		<aui:input label="" name="${oneAssessment.assessment.type}_comment" value="${oneAssessment.assessment.comment}" type="textarea" id="${oneAssessment.assessment.type}_comment" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			    	<!-- show only when primary caregiver status is in_process -->
			    	<c:if test="${vcg.primaryDispReason eq 'IN_PROCESS'}">
			    	<div id="action_${oneAssessment.assessment.type}">			    	
				    	<a class="btn-primary save-assessment" id="save_${oneAssessment.assessment.type}" style="${isDisabled ? 'display: none' : ''}"><i class="close-window btn btn-primary" >Save</i></a>
				    	<a class="btn-primary edit-assessment" id="edit_${oneAssessment.assessment.type}" style="${isDisabled ? '' : 'display: none'}"><i class="close-window btn btn-primary" >Edit</i></a>			    	
			    	</div>
			    	</c:if>
		    	</td>
		    	<td>
					<div>
						<a class="btn-link assessment-history icon-time btn-primary history_div_${oneAssessment.assessment.type}" id="${oneAssessment.assessment.assmtId}" title="<liferay-ui:message key="assmt-audit-log" />" >&nbsp;<liferay-ui:message key="history" /></a>
					</div>
		    	</td>
			</tr>
			</c:forEach>
		</table>
		</div>
		</c:if>
	
		<c:if test="${vcg.secondaryId gt 0 && (vcg.secondaryDispReason eq 'IN_PROCESS' || vcg.secondaryDispReason eq 'APPROVED' || vcg.secondaryDispReason eq 'REINSTATED') }">
		<div class="sectionHeading">Secondary Caregiver</div>
		<div class="summaryTable">
		<table style="width:98%">
			<tr>
			  <td width="100%" colspan='5' style="text-align:left;">Valid Application Received Date - ${secondaryValidAppDate}</td> 
			</tr>

			<tr>
			  <th width="30%">Assessment</th> 
			  <th width="10%">* Completion Date</th> 	  
			  <th width="30%">Comment/Note</th> 
			  <th width="15%">Action</th>
			  <th width="15%">History</th>			  
			</tr>
	
			<c:forEach var="oneAssessment" items="${form_['secondaryAssessmentList']}" >
			<c:set var="isDisabled" value="false"/>
			<c:if test="${vcg.secondaryDispReason eq 'APPROVED' || vcg.secondaryDispReason eq 'REINSTATED' || oneAssessment.assessment.assmtId gt 0}"><c:set var="isDisabled" value="true"/></c:if>
			<tr>
			    <td>
				    <input type="hidden" name="${oneAssessment.assessment.type}_caregiverId" value="${vcg.secondaryId}" id="${oneAssessment.assessment.type}_caregiverId"/>
				    <input type="hidden" name="${oneAssessment.assessment.type}_assessmentId" value="${oneAssessment.assessment.assmtId}" id="${oneAssessment.assessment.type}_assessmentId"/>
				    <liferay-ui:message key="${oneAssessment.assessment.type}_ui" />
				</td>
			    <td>
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass['comletionDate']}"  >
						<aui:input label="" name="${oneAssessment.assessment.type}_completionDate" value="${oneAssessment.formattedcompletionDate}" cssClass="date-field" type="text" id="${oneAssessment.assessment.type}_completionDate" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			  		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass}"  >
				 		<aui:input label="" name="${oneAssessment.assessment.type}_comment" value="${oneAssessment.assessment.comment}" type="textarea" id="${oneAssessment.assessment.type}_comment" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			    	<c:if test="${vcg.secondaryDispReason eq 'IN_PROCESS'}">
			    	<div id="action_${oneAssessment.assessment.type}">			    	
				    	<a class="btn-primary save-assessment" id="save_${oneAssessment.assessment.type}" style="${isDisabled ? 'display: none' : ''}"><i class="close-window btn btn-primary" >Save</i></a>
				    	<a class="btn-primary edit-assessment" id="edit_${oneAssessment.assessment.type}" style="${isDisabled ? '' : 'display: none'}"><i class="close-window btn btn-primary" >Edit</i></a>			    	
			    	</div>
			    	</c:if>
		    	</td>
		    	<td>
					<div>
						<a class="btn-link assessment-history icon-time btn-primary history_div_${oneAssessment.assessment.type}" id="${oneAssessment.assessment.assmtId}" title="<liferay-ui:message key="assmt-audit-log" />" >&nbsp;<liferay-ui:message key="history" /></a>
					</div>
		    	</td>
			</tr>
			</c:forEach>
		</table>
		</div>
		</c:if>
		
		<c:if test="${vcg.secondaryTwoId gt 0  && (vcg.secondaryTwoDispReason eq 'IN_PROCESS' || vcg.secondaryTwoDispReason eq 'APPROVED' || vcg.secondaryTwoDispReason eq 'REINSTATED') }">
		<div class="sectionHeading">Secondary Two Caregiver</div>
		<div class="summaryTable">
		<table style="width:98%">
			<tr>
			  <td width="100%" colspan='5' style="text-align:left;">Valid Application Received Date - ${secondaryTwoValidAppDate}</td> 
			</tr>

			<tr>
			  <th width="30%">Assessment</th> 
			  <th width="10%">* Completion Date</th> 	  
			  <th width="30%">Comment/Note</th> 
			  <th width="15%">Action</th>
			  <th width="15%">History</th>			  
			</tr>
	
			<c:forEach var="oneAssessment" items="${form_['secondaryTwoAssessmentList']}" >
			<c:set var="isDisabled" value="false"/>
			<c:if test="${ vcg.secondaryTwoDispReason eq 'APPROVED' || vcg.secondaryTwoDispReason eq 'REINSTATED' || oneAssessment.assessment.assmtId gt 0}"><c:set var="isDisabled" value="true"/></c:if>
			<tr>
			    <td>
				    <input type="hidden" name="${oneAssessment.assessment.type}_caregiverId" value="${vcg.secondaryTwoId}" id="${oneAssessment.assessment.type}_caregiverId"/>
				    <input type="hidden" name="${oneAssessment.assessment.type}_assessmentId" value="${oneAssessment.assessment.assmtId}" id="${oneAssessment.assessment.type}_assessmentId"/>
				    <liferay-ui:message key="${oneAssessment.assessment.type}_ui" />
				</td>
			    <td>
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass['comletionDate']}"  >
						<aui:input label="" name="${oneAssessment.assessment.type}_completionDate" value="${oneAssessment.formattedcompletionDate}" cssClass="date-field" type="text" id="${oneAssessment.assessment.type}_completionDate" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			  		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass}"  >
				 		<aui:input label="" name="${oneAssessment.assessment.type}_comment" value="${oneAssessment.assessment.comment}" type="textarea" id="${oneAssessment.assessment.type}_comment" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			    	<c:if test="${vcg.secondaryTwoDispReason eq 'IN_PROCESS'}">
			    	<div id="action_${oneAssessment.assessment.type}">			    	
				    	<a class="btn-primary save-assessment" id="save_${oneAssessment.assessment.type}" style="${isDisabled ? 'display: none' : ''}"><i class="close-window btn btn-primary" >Save</i></a>
				    	<a class="btn-primary edit-assessment" id="edit_${oneAssessment.assessment.type}" style="${isDisabled ? '' : 'display: none'}"><i class="close-window btn btn-primary" >Edit</i></a>			    	
			    	</div>
			    	</c:if>
		    	</td>
		    	<td>
					<div>
						<a class="btn-link assessment-history icon-time btn-primary history_div_${oneAssessment.assessment.type}" id="${oneAssessment.assessment.assmtId}" title="<liferay-ui:message key="assmt-audit-log" />" >&nbsp;<liferay-ui:message key="history" /></a>
					</div>
		    	</td>
			</tr>
			</c:forEach>
		</table>
		</div>
		</c:if>
	</div>		
	</div>
	</div>	


<div class="ongoing-assessments" id="ongoingAssessments">
	<div class="next-section-label section-header">
		<div class=" icon-list show-tooltip" title='<liferay-ui:message key="click-to-toggle-pane" />' > 
			<liferay-ui:message key="assessments-ongoing" />
		</div>
	</div>

	<div>
		<a class="btn-link ongoing-assmt-all icon-time btn-primary" id="${vcg.vcgId}" title="<liferay-ui:message key="ongoing-assmt-all" />" >&nbsp;<liferay-ui:message key="ongoing-assmt-all" /></a>
	</div>
	<div>
		<a class="btn-link ongoing-assmt-history-all icon-time btn-primary" id="${vcg.vcgId}" title="<liferay-ui:message key="assmt-audit-log" />" >&nbsp;<liferay-ui:message key="assmt-audit-all" /></a>
	</div>

	<hr/>
	
	<input type="hidden" name="section" value="${form_['section']}" id="section"/>	
	
	<div class="content toggler-content-expanded">

		<div class="summaryTable">
		<table style="width:98%">
			<tr>
			  <td width="100%" colspan='7' style="text-align:left;">Primary Caregiver Approval Date - ${primaryApprovalDate}</td> 
			</tr>
			<tr>
			  <th width="10%">Assessment</th> 
			  <th width="10%">Due Date</th> 
			  <th width="10%">* Mode of Assessment</th>  
			  <th width="10%">* Completion Date</th> 	
			  <th width="15%">Comment/Note (* if completed more than 45 days before or after due date)</th> 
			  <th width="10%">Action</th>
			  <th width="10%">History</th>			  
			</tr>

		<c:if test="${vcg.primaryDispReason eq 'APPROVED' || vcg.primaryDispReason eq 'REINSTATED'}">	
			<c:if test="${form_['periodicAssessmentSize'] gt 0}">
			<c:forEach var="oneAssessment" items="${form_['periodicAssessmentList']}" >	
			<c:set var="isDisabled" value="false"/>
			<c:if test="${not empty oneAssessment.assessment.mode}"><c:set var="isDisabled" value="true"/></c:if>
			<tr>
			    <td>
				    <input type="hidden" name="${oneAssessment.assessment.assmtId}_caregiverId" value="${vcg.primaryId}" id="${oneAssessment.assessment.assmtId}_caregiverId"/>
				    <input type="hidden" name="${oneAssessment.assessment.assmtId}_type" value="${oneAssessment.assessment.type}" id="${oneAssessment.assessment.assmtId}_type"/>
				    <liferay-ui:message key="${oneAssessment.assessment.type}" />
				</td>
			    <td>
			   	 	<input type="hidden" name="${oneAssessment.assessment.assmtId}_scheduleDate" value="${oneAssessment.formattedScheduleDate}" id="${oneAssessment.assessment.assmtId}_scheduleDate"/>
			    	<c:out value="${oneAssessment.formattedScheduleDate}" />
				</td>
				<td>
					<div class="assmt-mode" id="${oneAssessment.assessment.assmtId}_modediv">
					<aui:select label="" name="${oneAssessment.assessment.assmtId}_mode" id="${oneAssessment.assessment.assmtId}_mode" disabled="${isDisabled}">
						<aui:option value="" >Select</aui:option>
						<aui:option value="In-home" label="In-home" selected="${oneAssessment.assessment.mode eq 'In-home'}"/>
						<c:if test="${oneAssessment.assessment.type ne 'annual'}">
							<aui:option value="Telephone" label="Telephone" selected="${oneAssessment.assessment.mode eq 'Telephone'}"/>
							<aui:option value="TeleHealth" label="TeleHealth" selected="${oneAssessment.assessment.mode eq 'TeleHealth'}"/>
							<aui:option value="Facility Visit" label="Facility Visit" selected="${oneAssessment.assessment.mode eq 'Facility Visit'}"/>
						</c:if>
						<aui:option value="Not completed" label="Not completed" selected="${oneAssessment.assessment.mode eq 'Not completed'}"/>
					</aui:select>
					</div>					
				</td>			
			    <td>
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass['completionDate']}"  >
						<aui:input label="" name="${oneAssessment.assessment.assmtId}_completionDate" value="${oneAssessment.formattedcompletionDate}" cssClass="${oneAssessment.assessment.mode eq 'Not completed' ? '' : 'date-field'}" type="text" id="${oneAssessment.assessment.assmtId}_completionDate" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			  		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-td ${cssClass}"  >
				 		<aui:input label="" name="${oneAssessment.assessment.assmtId}_comment" value="${oneAssessment.assessment.comment}" type="textarea" id="${oneAssessment.assessment.assmtId}_comment" disabled="${isDisabled}"/>
					</aui:field-wrapper>
				</td>
			    <td>
			    	<div id="action_${oneAssessment.assessment.assmtId}">			    	
				    	<a class="btn-primary save-assessment" id="save_${oneAssessment.assessment.assmtId}" style="${isDisabled ? 'display: none' : ''}"><i class="close-window btn btn-primary" >Save</i></a>
				    	<a class="btn-primary edit-per-assessment" id="edit_${oneAssessment.assessment.assmtId}" style="${isDisabled ? '' : 'display: none'}"><i class="close-window btn btn-primary" >Edit</i></a>			    	
			    	</div>
		    	</td>
		    	<td>
					<div>
						<a class="btn-link assessment-history icon-time btn-primary history_div_${oneAssessment.assessment.assmtId}" id="${oneAssessment.assessment.assmtId}" title="<liferay-ui:message key="assmt-audit-log" />" >&nbsp;<liferay-ui:message key="history" /></a>
					</div>
		    	</td>
			</tr>
			</c:forEach>
			</c:if>
			<c:if test="${form_['periodicAssessmentSize'] eq 0}">
				<tr>
					<td colspan=7><liferay-ui:message key="no-periodic-assmt-found" /></td>
				</tr>	
			</c:if>
		</c:if>
		<c:if test="${vcg.primaryDispReason ne 'APPROVED' && vcg.primaryDispReason ne 'REINSTATED'}">	
			<tr>
				<td colspan=7>Primary caregiver not in Approved or Reinstated state</td>
			</tr>				
		</c:if>	
		
		</table>
		</div>
	</div>
</div>
	
</fieldset>
	

				<c:if test="${!empty results_['vcgClosedRefs'] || !empty results_['vcgOpenRefs']  }">
					
					
					<aui:script use="aui-modal" >
						var modalAudit = new A.Modal(
								{
									headerContent : '<h4><liferay-ui:message key="work-audit" /></h4>',
									bodyContent : A.one("#audit_work_entry"),
									centered : true,
									destroyOnHide : false,
									modal : true,
									render : '#modalAuditRef',
									resizable : {
										handles : 'b, r'
									},
									visible : false,
									width : 700
								});
						window.auditLog = function(src) {
							window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="workAudit"/></portlet:resourceURL>', 'html', 
										{ classPk: src },
										function( data ){
											overwrite( A.one( '#audit_work_entry' ), data );
											modalAudit.show();
										} 
								);
						}
					</aui:script>
				</c:if>

<div class="work-items">
	<div class="next-section-label section-header">
		<div class=" icon-list show-tooltip" title='<liferay-ui:message key="click-to-toggle-pane" />' > 
			<liferay-ui:message key="open-referrals" />
				
		</div>
	</div>
	<hr/>
	<div class="content toggler-content-${showSection}">
		<%@include file="/jsp/internal/vcgOpenRefs.jsp" %>
	</div>
</div>
	
<div class="work-items">
	<div class="next-section-label section-header">
		<div class=" icon-list show-tooltip" title='<liferay-ui:message key="click-to-toggle-pane" />' > 
			<liferay-ui:message key="closed-referrals" />
		</div>
	</div>
	<hr/>
	<div class="content toggler-content-${showSection}">
		<%@include file="/jsp/internal/vcgClosedRefs.jsp" %>
	</div>
</div>

<div class="vcg-notes">
	<div class="next-section-label section-header">
		<div class=" icon-list show-tooltip" title='<liferay-ui:message key="click-to-toggle-pane" />' > 
			<liferay-ui:message key="vcg-notes" />
		</div>
	</div>
	<hr/>
	<div class="content toggler-content-${showSection}" id="vcgNotes" >
		<%@include file="/jsp/internal/vcgNotes.jsp" %>
	</div>
</div>	


	
<aui:script use="aui-base,aui-toggler">
	window.loadNotes = function ( note ) {
		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadVcgNotes" /><portlet:param name="page" value="vcgNotes" /><portlet:param name="classPk" value="${vcg.vcgId}" /><portlet:param name="fromParameter" value="true" /></portlet:resourceURL>', 'html', 
			{ note: note },
			function( data ){ 
				overwrite( A.one( "#vcgNotes" ), data );
				A.one('#<portlet:namespace/>addNode_comments').val("");
			} 
		);
	}
	
	A.on('domready', loadNotes );
	
     
	
</aui:script>

<portlet:actionURL var="addVcgNote">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="addVcgNote"/>
</portlet:actionURL>

<div id="addVcgNote">
	<aui:form action="${addVcgNote}" method="post" name="addNote_fm"  >
	
	<input type="hidden" name="<portlet:namespace/>vcgId" value="${vcg.vcgId}" id="<portlet:namespace/>addNode_vcgId" >
			
	<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="manage-layout-medium-input ${cssClass}" >
 		<aui:input label="new-vcg-note" name="addNode_comments" id="addNode_comments" size="35" type="textarea"  />
	</aui:field-wrapper>
		
	</aui:form>
</div>
	
	<input type="hidden" id="<portlet:namespace/>placeHolder" />
<!--	
	<div class="manage-layout manage-layout-shim">
		<c:if test="${! empty form_['documId'] and form_['documId'] gt 0}">
			<portlet:resourceURL var="getDocum">
				<portlet:param name="action" value="getDocum"/>
				<portlet:param name="documId" value="${form_['documId']}"/>
			</portlet:resourceURL>
			
			<div class="poa-docum manage-layout" >
				<a href="${getDocum}" target="_blank" ><i class="icon-download" >&nbsp; ${form_['documName']}</i></a>
			</div>
		</c:if>
	</div>
-->	
	
	
<portlet:actionURL var="saveEntry">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="saveEntry"/>
	<portlet:param name="entry" value="vcg" />
</portlet:actionURL>

<div class="yui3-skin-sam">
	<aui:form name="sign_fm" method="post"  action="${saveEntry}"  >
		<input type="hidden" name="vcgId" value="${vcg.vcgId}" >
		
    	<div id="modalUpdateVcg">
    	</div>
    </aui:form>
</div>
 <div id="edit_vcg_entry">
</div>

<div class="yui3-skin-sam">
   	<div id="modalEligibility">
   	</div>
</div>
 <div id="eligibility_entry">
</div>


<div class="yui3-skin-sam">
   	<div id="modalAuditVcg">
   	</div>
</div>
 <div id="audit_vcg_entry">
</div>

<div class="yui3-skin-sam">
   	<div id="modalAuditRef">
   	</div>
</div>	
<div id="audit_work_entry">
</div>

<div class="yui3-skin-sam">
	<div id="modalCreateNote"></div>
</div>

	<aui:script use="aui-tooltip,aui-modal,io-form,querystring-stringify">
			new A.TooltipDelegate( { trigger: 'div .mini, .vcg-entry-menu .btn-link, .vcg-entry-menu .icon-time, .vcg-entry-menu .icon-plus, .icon-time .icon-ok, .upper-icon-padding' } );
			
			
			//var assessmentCount = 0${form_['assessments'].size()};
			
			//A.one('#<portlet:namespace/>scheduleAssessment').on(
			//	      'click',
		    // 	function( ) {
		    //		var newAssessments = 1 + Number( A.one('#<portlet:namespace/>newAssessments').val() );
		    //		var nextAssessment = A.one('#<portlet:namespace/>assessmentNext'+ newAssessments );
		    //		if ( nextAssessment.hasClass('hidden-element') ){
			//    		nextAssessment.removeClass('hidden-element');
		    //		} else {
		    //			return false;
		    //		}
		    //		A.one('#<portlet:namespace/>newAssessments').val( newAssessments );
		    //		nextAssessment.addClass('active-element');
		    // 	}
		    //);
			
			
			var modal = new A.Modal({
				headerContent: '<h4><liferay-ui:message key="update-vcg-entry-header" /></h4>',
		        bodyContent: A.one("#edit_vcg_entry"),
		        centered: true,
		        destroyOnHide: false,
		        modal: true,
		        render: '#modalUpdateVcg',
		        resizable: {
		          handles: 'b, r'
		        },
		        visible: false,
		        width: 1000
		    });
			
			
		window.preventUser = function() {
			return "<liferay-ui:message key='back-button-lose-form-data' />";
		}
		window.addEventListener('beforeunload', preventUser);
		
		A.all("#breadcrumbs a, .collapse nav-collapse, .nav-away").on('click', function(){
			window.removeEventListener('beforeunload',preventUser);
		});
			
			modal.addToolbar([
			                         {
			                           label: 'Cancel',
			                           on: {
			                             click: function() {
			                            	 modal.hide();
			                             }
			                           }
			                         },{
			                           label: 'Update',
			                           on: {
			                             click: function() {
                            		    	validateFields( function ( message ) {
                            		    		var validationNotice = A.one ('#_validationResult');
                           			    		if ( message.length > 0 ){
                           		    				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
                           		    				validationNotice.html(msg);
                           		    				//modal.footerNode.insert(validationNotice);
                           				    		return false;	
                           			    		}
                           			    		window.removeEventListener('beforeunload',preventUser);
				                            	A.one('#<portlet:namespace/>sign_fm').submit();	
                            		    	});

			                             }
			                           }
			                         }
			                    ]);
		    
			
			
			A.all('.edit-vcg-entry').on(
				      'click',
				      function( event ) {
				    	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadVcgEntry" /><portlet:param name="page" value="editVcgEntry"/></portlet:resourceURL>', 'html', 
									{ persnId: event.currentTarget.ancestor('.vcg-entry-menu').attr('id'),
				    	  				vcgId: '${vcg.vcgId}'
									},
									function( data ){
										overwrite( A.one( '#edit_vcg_entry' ), data );
										
										modal.footerNode.all('.portlet-msg-alert').each( function (msg){
											msg.hide();	
										});
										modal.headerNode.one('h4').html('<liferay-ui:message key="update-vcg-entry-header" />');
										modal.render();
							        	modal.show();
							        	window.enforceFormats();
							        	modal.footerNode.insert(A.one ('#_validationResult'));
							        	try{
								        	A.one(".btn-link.short-facility-list.btn-primary.facil-magnet").setStyle('margin-top', '-30px');
							        	} catch(e){}
									} 
							);
				     }
				 );
			
			A.all('.edit-disposition').on(
				      'click',
				      function( event ) {
				    	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadDisposition" /><portlet:param name="page" value="editDisposition"/></portlet:resourceURL>', 'html', 
									{ persnId: event.currentTarget.ancestor('.vcg-entry-menu').attr('id'),
										MODE: 1,
				    	  				vcgId: '${vcg.vcgId}'
									},
									function( data ){
										overwrite( A.one( '#edit_vcg_entry' ), data );
										
										modal.footerNode.all('.portlet-msg-alert').each( function (msg){
											msg.hide();	
										});
										modal.headerNode.one('h4').html("Process Disposition");
										modal.render();
							        	modal.show();
							        	window.enforceFormats();
							        	modal.footerNode.insert(A.one ('#_validationResult'));
									} 
							);
				     }
				 );
			
				A.all('.create-vcg-entry').on(
				    'click',
				    function( event ) {
				    	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadGeneral" /><portlet:param name="page" value="editGeneral"/><portlet:param name="strip" value="0"/></portlet:resourceURL>', 'html', 
									{ 
				    	  				vcgId: '${vcg.vcgId}',
				    	  				MODE: 3
									},
									function( data ){
										overwrite( A.one( '#edit_vcg_entry' ), data );
										
										modal.footerNode.all('.portlet-msg-alert').each( function (msg){
											msg.hide();	
										});
										modal.render();
							        	modal.show();
							        	window.enforceFormats();
							        	modal.footerNode.insert(A.one ('#_validationResult'));
									} 
							);
				    });
			
			A.all('.edit-tier').on(
				      'click',
				      function( event ) {
				    	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadTier" /><portlet:param name="page" value="editTier"/></portlet:resourceURL>', 'html', 
									{ persnId: event.currentTarget.ancestor('.vcg-entry-menu').attr('id'),
				    	  				vcgId: '${vcg.vcgId}',
				    	  				MODE: 2
									},
									function( data ){
										overwrite( A.one( '#edit_vcg_entry' ), data );
										
										modal.footerNode.all('.portlet-msg-alert').each( function (msg){
											msg.hide();	
										});
										modal.render();
							        	modal.show();
							        	window.enforceFormats();
							        	modal.footerNode.insert(A.one ('#_validationResult'));
									} 
							);
				     }
				 );
			
			
			var modalH = new A.Modal({
				headerContent: '<h4><liferay-ui:message key="audit-vcg-entry-header" /></h4>',
		        bodyContent: A.one("#audit_vcg_entry"),
		        centered: true,
		        destroyOnHide: false,
		        modal: true,
		        render: '#modalAuditVcg',
		        resizable: {
		          handles: 'b, r'
		        },
		        visible: false,
		        width: 1000
		    });
			
			A.all('.audit-vcg-entry').on(
				      'click',
				      function( event ) {
				    	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="persnAudit"/></portlet:resourceURL>', 'html', 
									{ classPk: event.currentTarget.ancestor('.vcg-entry-menu').attr('id'),
				    	  				vcgId: '${vcg.vcgId}'
									},
									function( data ){
										overwrite( A.one( '#audit_vcg_entry' ), data );
										modalH.render();
										modalH.show();
									} 
							);
				     }
				 );
			
			var modalE = new A.Modal({
				headerContent: '<h4><liferay-ui:message key="eligibility-header" /></h4>',
		        bodyContent: A.one("#eligibility_entry"),
		        centered: true,
		        destroyOnHide: false,
		        modal: true,
		        render: '#modalEligibility',
		        resizable: {
		          handles: 'b, r'
		        },
		        visible: false,
		        width: 750
		    });
			
			A.all('.view-eligibility').on(
				      'click',
				      function( event ) {
	    					if ( A.one('#modalEligibility').hasClass('loaded-pane') ){
	    						modalE.render();
								modalE.show();
	    						return false;
	    					}
	    					A.one('#modalEligibility').addClass('loaded-pane');
				      		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadEligibility" /><portlet:param name="classPk" value="${vcg.veteranId}" /></portlet:resourceURL>', 'html', 
									{},
									function( data ){
										overwrite( A.one( '#eligibility_entry' ), data );
										modalE.render();
										modalE.show();
									} 
							);
				     }
				 );
			
			var needServiceCall = false;
			
			var validateFields = function ( anotherCallback ){
				  
				  var count = 0;
				  var inputNodes = A.all('.required-input input, .required-input select, .required-input textarea');
				  var fields = "";
				  for ( var i = 0; i < inputNodes.size() ; i++ ){
					  var node = A.one(inputNodes._nodes[i]);
					  if (node == undefined  || node.attr('disabled') == true ) continue;
						if ( 'select-one' == node.attr('type') ){
			    			if ( node.val() == "" || node.val() == "0" ){
			    				 node.addClass( 'missing-required-input' );
			    				 fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
			    				 count++;
			    			} else {
			    				if ( node.hasClass('missing-required-input') ){
			    					node.removeClass( 'missing-required-input' );
			    				}
			    			}
			    		}
						if ( 'text' == node.attr('type') || 'textarea' == node.attr('type') ){
							if ( node.val() == ""   
								|| ( node.hasClass('date-field') && node.val() == 'MM/DD/YYYY' )
								|| ( node.hasClass('ssn-field') && node.val() == '###-##-####' )
								|| ( node.hasClass('email-field') && node.val() == '[USERNAME]@[DOMAIN]' )
								|| ( node.hasClass('phone-field') && node.val() == '(###) ###-####' ) ){
			   					node.addClass( 'missing-required-input' );
			   					var custom = node.ancestorsByClassName("required-input")._nodes[0].getAttribute('data-custom-message');
			   					if ( custom ) {
			   						fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim() + ": " + custom + "</li>"; 
			   					} else {
			   						fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
			   					}
			   					count++;
				   			} else {
				   				if ( node.hasClass('missing-required-input') ){
				   					node.removeClass( 'missing-required-input' );
				   				}
				   				if ( node.hasClass ('not-future') ){
				   					var parts = (""+node.val()).replace(/\W/g, '').match(/^(\d{2})(\d{2})(\d{4})$/);
				   					
				   					if ( parts ){
										  var input = new Date ( parseInt ( parts[3], 10 ), (parseInt ( parts[1], 10 ) -1), parts[2] );
										  var future = new Date ();
										  if ( input > future ){
											  fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" cannot be in future</li>";
										  }

									  }
				   				}
				   				if ( node.hasClass ('after-status-date') ) {
				   					
				   					var statusDate = node.ancestorsByClassName("required-input")._nodes[0].getAttribute('data-statusDate');
				   					//var statusDate = A.one('#statusDate').val();
				   					
				   					var appRc = (""+statusDate).replace(/\W/g, '').match(/^(\d{2})(\d{2})(\d{4})$/);
				   					var parts = (""+node.val()).replace(/\W/g, '').match(/^(\d{2})(\d{2})(\d{4})$/);
				   					if ( parts && appRc ){
										  var input = new Date ( parseInt ( parts[3], 10 ), (parseInt ( parts[1], 10 ) -1), parts[2] );
										  var recvd = new Date ( parseInt ( appRc[3], 10 ), (parseInt ( appRc[1], 10 ) -1), appRc[2] );
										  if ( recvd > input ){
											  fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" cannot be before " + statusDate + "</li>";
										  }
									}
				   				}
				   				if ( node.hasClass ('not-max-date') ){
				   					var maxDate = node.ancestorsByClassName("required-input")._nodes[0].getAttribute('data-maxDate');
				   					
				   					var max = (""+maxDate).replace(/\W/g, '').match(/^(\d{2})(\d{2})(\d{4})$/);
				   					var parts = (""+node.val()).replace(/\W/g, '').match(/^(\d{2})(\d{2})(\d{4})$/);
				   					if ( parts && max ){
										  var input = new Date ( parseInt ( parts[3], 10 ), (parseInt ( parts[1], 10 ) -1), parts[2] );
										  var beyVal = new Date ( parseInt ( max[3], 10 ), (parseInt ( max[1], 10 ) -1), max[2] );
										  if ( beyVal < input ){
											  fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" cannot be after " + maxDate + "</li>";
										  }
									}
				   				}
				   				
							}
				    	}
				    }
				    anotherCallback( fields );
			  }
			
			window.addNote = function(src) {
		modalAddNote.render();
		modalAddNote.show();
	}

	var modalAddNote = new A.Modal(
			{
				headerContent : '<h4><liferay-ui:message key="vcg-add-note" /></h4>',
				bodyContent : A.one("#addVcgNote"),
				centered : true,
				destroyOnHide : false,
				modal : true,
				render : '#modalCreateNote',
				resizable : {
					handles : 'b, r'
				},
				visible : false,
				width : 650
			});

	modalAddNote.addToolbar([ {
		label : 'Cancel',
		on : {
			click : function() {
				modalAddNote.hide();
			}
		}
	}, {
		label : 'Update',
		on : {
			click : function() {
				var note = A.one('#<portlet:namespace/>addNode_comments').val();
				if ( note != "" ){ 
				  validateFields( function ( message ) {
		    		var validationNotice = A.one ('#_validationResult');
			    		if ( message.length > 0 ){
		    				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
		    				validationNotice.html(msg);
		    				modalAddNote.footerNode.insert(validationNotice);
				    		return false;	
			    		}
			    		loadNotes( note );
			    		modalAddNote.hide();
		    	  }, '#addVcgNote');
		    	}
			}
		}
	} ]);
			
			
	</aui:script>
	
	<aui:script use="aui-base,aui-toggler">
	
	window.<portlet:namespace />toggler = new A.TogglerDelegate(
    {
       animated: true,
       closeAllOnExpand: false,
       container: '#sectionCollapse',
       content: '.content',
       //expanded: false,
       header: '.section-header',
       transition: {
         duration: 0.2,
         easing: 'cubic-bezier(0, 0.1, 0, 1)'
       }
     }
   );
	
	
	if ( false | ${showAssessments eq true} )
	{
		A.on('domready', function(event){
			try{
				window.<portlet:namespace />toggler.createAll();
				window.<portlet:namespace />toggler.items[0].collapse();
				window.<portlet:namespace />toggler.items[1].collapse();
				window.<portlet:namespace />toggler.items[2].collapse();
			}catch(e){}
		});

	}	


	
	 window.modalAssmtDataValidation = new A.Modal({
		    headerContent: '<h4><liferay-ui:message key="data-validation-header" /> </h4>',
		    bodyContent: A.one("#assmtValidationDiv"),
		    centered: true,
		    destroyOnHide: false,
		    modal: true,
		    render: '#assmtValidationModal',
		    resizable: {
		      handles: 'b, r'
		    },
		    visible: false,
		    width: 600
	});
	
	
	A.all('.save-assessment').on('click',function( event ) {
		var message = "";		
		var vcgId = '${vcg.vcgId}';
	 	var id = event.currentTarget.attr('id');	 	
	 	var idStr = id.substring(5);   
	 	var type = "";
		var assessmentId = "";		
		var completionDate = "";
		var comment = "";
		var caregiverId = "";		
		var assmtMode = "";				
		var assmt = "";
		var futureCompletionDate = "";
		
		if(idStr=="primaryClinical" || idStr=="primaryAssessment" || idStr=="primaryTraining" || idStr=="primaryInHome" 
			|| idStr=="secondaryClinical" || idStr=="secondaryAssessment" || idStr=="secondaryTraining" 
			|| idStr=="secondaryTwoClinical" || idStr=="secondaryTwoAssessment" || idStr=="secondaryTwoTraining")
		{	
			assmt="initial";
		}else{
			assmt="periodic";
		}
		
		if(assmt=="initial")
		{
		 	type = id.substring(5);
			assessmentId = A.one('#'+type+'_assessmentId').val();		
			completionDate = A.one('#<portlet:namespace/>'+type+'_completionDate').val();
			comment = A.one('#<portlet:namespace/>'+type+'_comment').val();
			caregiverId = A.one('#'+type+'_caregiverId').val();
		}else 
		{
			assessmentId = id.substring(5);
		 	type = A.one('#'+assessmentId+'_type').val();		
			completionDate = A.one('#<portlet:namespace/>'+assessmentId+'_completionDate').val();
			comment = A.one('#<portlet:namespace/>'+assessmentId+'_comment').val();
			caregiverId = A.one('#'+assessmentId+'_caregiverId').val();		
			assmtMode = A.one('#<portlet:namespace/>'+assessmentId+'_mode').val();				
		}		
		
		/*
		var typeList = [ "primaryClinical", "primaryAssessment", "primaryTraining", "primaryInHome", "secondaryClinical", "secondaryAssessment", "secondaryTraining", "secondaryTwoClinical", "secondaryTwoAssessment", "secondaryTwoTraining", "quarter1", "quarter2", "quarter3", "annual" ]
		var arrayLength = typeList.length;
		
		for (var i = 0; i < arrayLength; i++) {
		
			if( A.one('#<portlet:namespace/>'+typeList[i]+'_completionDate')!=null){
			    A.one('#<portlet:namespace/>'+typeList[i]+'_completionDate').removeClass( 'missing-required-input' );
			}		
		}
		*/
		
		var elements = document.getElementsByClassName('missing-required-input');
		while(elements.length > 0){
		    elements[0].classList.remove('missing-required-input');
		}
				
		if(assmt=="periodic" && assmtMode && assmtMode=="Not completed"){
			//console.log("assmt mode for periodic assmt is not completed..do not validate completion date");
		}else if(!completionDate || completionDate=='MM/DD/YYYY'){
			message = "<li>Completion Date is required</li>";
			if(assmt=="initial"){
				A.one('#<portlet:namespace/>'+type+'_completionDate').addClass( 'missing-required-input' );
			}else if(assmt=="periodic"){
				A.one('#<portlet:namespace/>'+assessmentId+'_completionDate').addClass( 'missing-required-input' );
			}
		}else {
			var inputDate = new Date(completionDate);
			var todaysDate = new Date();

			if(inputDate.setHours(0,0,0,0) > todaysDate.setHours(0,0,0,0)) {
				message = message + "<li>Completion Date cannot be a future date.</li>";
				if(assmt=="initial"){
					A.one('#<portlet:namespace/>'+type+'_completionDate').addClass( 'missing-required-input' );
				}else if(assmt=="periodic"){
					A.one('#<portlet:namespace/>'+assessmentId+'_completionDate').addClass( 'missing-required-input' );
					futureCompletionDate = "yes";
				}				
			}
		}	

		if(type == 'primaryAssessment'){
			var completionDateCompare = new Date(completionDate);
			var appReceiveDate = new Date('${primaryValidAppDate}');
			
			if(completionDateCompare.valueOf() < appReceiveDate.valueOf()){
				message = message + "<li>Caregiver Assessment date cannot be before the Valid Application Received Date</li>";
				A.one('#<portlet:namespace/>primaryAssessment_completionDate').addClass( 'missing-required-input' );
			}
		}
		
		if(type == 'secondaryAssessment'){
			var completionDateCompare = new Date(completionDate);
			var appReceiveDate = new Date('${secondaryValidAppDate}');
			
			if(completionDateCompare.valueOf() < appReceiveDate.valueOf()){
				message = message + "<li>Secondary Caregiver Assessment date cannot be before the Valid Application Received Date</li>";
				A.one('#<portlet:namespace/>secondaryAssessment_completionDate').addClass( 'missing-required-input' );
			}
		}

		if(type == 'secondaryTwoAssessment'){
			var completionDateCompare = new Date(completionDate);
			var appReceiveDate = new Date('${secondaryTwoValidAppDate}');
			
			if(completionDateCompare.valueOf() < appReceiveDate.valueOf()){
				message = message + "<li>Secondary Two Caregiver Assessment date cannot be before the Valid Application Received Date</li>";
				A.one('#<portlet:namespace/>secondaryTwoAssessment_completionDate').addClass( 'missing-required-input' );
			}			
		}
		
		
		
		//NOTE : check periodic note - if completion date is more than 45 days from schedule date, then note is required
		
		//if(type == 'quarter1' || type=='quarter2' || type=='quarter3' || type=='annual')
		if(assmt=="periodic")
		{
			if(!assmtMode)
			{
				message = message + "<li>Mode of Assessment is required</li>";
				A.one('#<portlet:namespace/>'+assessmentId+'_mode').addClass( 'missing-required-input' );	
			}
			
			var scheduleDate = A.one('#'+assessmentId+'_scheduleDate').val();				
			var scheduleDateCompare = new Date(scheduleDate);
			var completionDateCompare = new Date(completionDate);
			var interval = ((completionDateCompare - scheduleDateCompare)/(24*60*60*1000));
			if(interval>61 || interval<-61){
				message = message + "<li>Completion date entered is not in the range for assessment compliance</li>";
				A.one('#<portlet:namespace/>'+assessmentId+'_completionDate').addClass( 'missing-required-input' );
			}else if(!comment && !futureCompletionDate && (interval>45 || interval<-45)){
				message = message + "<li>Comment is required</li>";
				A.one('#<portlet:namespace/>'+assessmentId+'_comment').addClass( 'missing-required-input' );
			}	
		}
		
		//alert("completion date is : "+completionDate);
			
		if ( message.length > 0 ){
			modalAssmtDataValidation.render();
			modalAssmtDataValidation.show();
			var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
			A.one ('#assmtValidationResult').html(msg);
		}else{
			window.caretIo( '<portlet:resourceURL><portlet:param name="javax.portlet.action" value="doAction"/><portlet:param name="action" value="saveAssessment"/></portlet:resourceURL>', 'json',
		    {
				vcgId:'${vcg.vcgId}',
				groupId:'${vcg.groupId}',
				type: type,
				//assessmentId: A.one('#'+type+'_assessmentId').val(),
				assessmentId: assessmentId,
				//completionDate: A.one('#<portlet:namespace/>'+type+'_completionDate').val(),
				//comment: A.one('#<portlet:namespace/>'+type+'_comment').val(),
				//caregiverId: A.one('#'+type+'_caregiverId').val(),
				completionDate:completionDate,
				comment:comment,
				caregiverId:caregiverId,
				veteranId: '${veteranId}',
				assmtMode: assmtMode
	        },
	        function( data ) {
	    	   	var assessmentId = data.assessmentId;
	    	   	
	    	   	if(assmt=="initial")
	    	   	{
		    	   	A.one('#'+type+'_assessmentId').attr('value',assessmentId);
		    	   	A.one('#<portlet:namespace/>'+type+'_completionDate').attr('disabled',true);
		    	   	A.one('#<portlet:namespace/>'+type+'_comment').attr('disabled',true);
	
		    	   	document.getElementById('edit_'+type).style.display = '';
		    	   	document.getElementById('save_'+type).style.display = 'none';
		    	   	
		    	   	A.one('.history_div_'+type).attr('id',assessmentId);
	    	   	}else if(assmt=="periodic")
	    	   	{
		    	   	A.one('#<portlet:namespace/>'+assessmentId+'_completionDate').attr('disabled',true);
		    	   	A.one('#<portlet:namespace/>'+assessmentId+'_comment').attr('disabled',true);
		    	   	A.one('#<portlet:namespace/>'+assessmentId+'_mode').attr('disabled',true);
		
		    	   	document.getElementById('edit_'+assessmentId).style.display = '';
		    	   	document.getElementById('save_'+assessmentId).style.display = 'none';
		    	   	
		    	   	//do this only when a new assessment is added
		    	   	if(data.assessmentStatus=="created")
		    	   	{		 
		    	   		window.removeEventListener('beforeunload',preventUser);   	   	
		    	   		A.one('#<portlet:namespace/>reload_fm').submit();	
		    	   	}
	    	   	}
	       	});
		}
	});
	
	A.all('.edit-assessment').on('click',function( event ) {
		var id = event.currentTarget.attr('id');	 	   
	 	var type = id.substring(5);

		A.one('#<portlet:namespace/>'+type+'_completionDate').attr('disabled',false);
	   	A.one('#<portlet:namespace/>'+type+'_comment').attr('disabled',false);	  
	   	document.getElementById('save_'+type).style.display = '';
	    document.getElementById('edit_'+type).style.display = 'none';
	});
	
	
	A.all('.edit-per-assessment').on('click',function( event ) {
		var id = event.currentTarget.attr('id');	 	   
	 	var assmtId = id.substring(5);

		A.one('#<portlet:namespace/>'+assmtId+'_completionDate').attr('disabled',false);
	   	A.one('#<portlet:namespace/>'+assmtId+'_comment').attr('disabled',false);	  
	   	
  		if(A.one('#<portlet:namespace/>'+assmtId+'_mode')!=null){
   	   		A.one('#<portlet:namespace/>'+assmtId+'_mode').attr('disabled',false);
   	   	}
	   	
	   	document.getElementById('save_'+assmtId).style.display = '';
	    document.getElementById('edit_'+assmtId).style.display = 'none';
	});
	
	
	 var modalAssmtHistory = new A.Modal({
		headerContent: '<h4><liferay-ui:message key="assmt-audit-header" /></h4>',
        bodyContent: A.one("#assmtHistoryDiv"),
        centered: true,
        destroyOnHide: false,
        modal: true,
        render: '#assmtHistoryModal',
        resizable: {
          handles: 'b, r'
        },
        visible: false,
        width: 1000
    });
	
	A.all('.assessment-history').on('click', function( event ) {
  	 	var id = event.currentTarget.attr('id');	 	   
		//var id = event.currentTarget.ancestor('.history-div').attr('id');
		//console.log("assessment id from div is : "+ id);
		
   	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="assmtAudit"/></portlet:resourceURL>', 'html', 
			{ 
	   	  		assmtId: id
	 		},
			function( data )
			{
				overwrite( A.one( '#assmtHistoryResult' ), data );
				modalAssmtHistory.render();
				modalAssmtHistory.show();
			}  		
		);
	});

	
	A.all('.assessment-history-all').on('click', function( event ) {
  	 	var id = event.currentTarget.attr('id');	 	   
		
   	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="assmtAuditAll"/></portlet:resourceURL>', 'html', 
			{ 
   	  			vcgId:'${vcg.vcgId}'
	 		},
			function( data )
			{
				overwrite( A.one( '#assmtHistoryResult' ), data );
				modalAssmtHistory.render();
				modalAssmtHistory.show();
			}  		
		);
	});
	
	
	A.all('.ongoing-assmt-history-all').on('click', function( event ) {
  	 	var id = event.currentTarget.attr('id');	 	   
		
   	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="assmtAuditPeriodicAll"/></portlet:resourceURL>', 'html', 
			{ 
   	  			vcgId:'${vcg.vcgId}'
	 		},
			function( data )
			{
				overwrite( A.one( '#assmtHistoryResult' ), data );
				modalAssmtHistory.render();
				modalAssmtHistory.show();
			}  		
		);
	});
	
	A.all('.assmt-mode').on('change',function( event ) {
	
		var elements = document.getElementsByClassName('missing-required-input');
		while(elements.length > 0){
		    elements[0].classList.remove('missing-required-input');
		}
		
		//console.log("reached change mode");
		var id = event.currentTarget.attr('id');
		//console.log("id is : "+id);
		var assmtId = id.substring(0, id.indexOf('_'));
		//console.log("assmtId is : "+assmtId);
		
		var assmtMode = A.one('#<portlet:namespace/>'+assmtId+'_mode').val();
		//console.log("assmtMode is : "+assmtMode);
		
		if(assmtMode=="Not completed"){
			//console.log("assmtMode is not completed...disabling the completion date");
			var completionDate = A.one('#<portlet:namespace/>'+assmtId+'_completionDate').val();
			//console.log("completion date : "+completionDate);
			
			A.one('#<portlet:namespace/>'+assmtId+'_completionDate').attr('disabled',true);	
			A.one('#<portlet:namespace/>'+assmtId+'_completionDate').val("");	
		}else{
			A.one('#<portlet:namespace/>'+assmtId+'_completionDate').attr('disabled',false);	
			A.one('#<portlet:namespace/>'+assmtId+'_completionDate').attr('cssClass', 'date-field');
		}
	
	});
	

	var modalPeriodicAssmt = new A.Modal({
		headerContent: '<h4><liferay-ui:message key="periodic-assmt-header" /></h4>',
        bodyContent: A.one("#periodicAssmtDiv"),
        centered: true,
        destroyOnHide: false,
        modal: true,
        render: '#periodicAssmtModal',
        resizable: {
          handles: 'b, r'
        },
        visible: false,
        width: 1000
    });

	A.all('.ongoing-assmt-all').on('click', function(event) {
  	  	window.caretIo('<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="periodicAssessmentsAll"/></portlet:resourceURL>', 'html', 
			{ 
   	  			vcgId:'${vcg.vcgId}',
   	  			primaryId:'${vcg.primaryId}'
	 		},
			function(data)
			{
				overwrite(A.one('#periodicAssmtAllResult'), data);
				modalPeriodicAssmt.render();
				modalPeriodicAssmt.show();
			}  		
		);
	});
	
	
	var deleteDocId = '';
	A.all('.delete-document').on('click', function( event ) 
	{
  	 	window.deleteDocId = event.currentTarget.attr('id');	 	   
		//console.log("document id from div is : "+ window.deleteDocId);
		
		A.one('#<portlet:namespace/>delete_doc_comment').html('');
		A.one('#<portlet:namespace/>delete_doc_comment').removeClass('missing-required-input');
		
		A.one('#deleteDocValidation').html('');
		document.getElementById('deleteDocValidation').style.display = 'none';
				 	  	
		modalDeleteDocument.render();
		modalDeleteDocument.show();		
	});
	
	window.modalDeleteDocument = new A.Modal({
	    headerContent: '<h4><liferay-ui:message key="delete-document" /> </h4>',
	    bodyContent: A.one("#deleteDocDiv"),
	    centered: true,
	    destroyOnHide: false,
	    modal: true,
	    render: '#deleteDocModal',
	    resizable: {
	      handles: 'b, r'
	    },
	    visible: false,
	    width: 800
	});
	 
	 modalDeleteDocument.addToolbar([
	   {
         label: 'Cancel',
         on: {
	            click: function() {
	            	window.deleteDocId = '';
	            	modalDeleteDocument.hide();
              	}
          }
	   },
	   {
          label: 'Delete',
          id: 'modalDelete',
          on: {
              click: function() {
              
              	//var id = event.currentTarget.attr('id');	 	   
				//console.log("again ... document id from div is : "+ window.deleteDocId);
				 
				var comment = A.one('#<portlet:namespace/>delete_doc_comment').val();
				//console.log("document delete comment is : "+ comment);
 
	            if (!comment){
	            	var txt = "Reason for Deletion is required";
					var msg = "<div class='portlet-msg-alert'>" + txt +"</div>";
	 				A.one('#<portlet:namespace/>delete_doc_comment').addClass( 'missing-required-input' );
	 				A.one ('#deleteDocValidation').html(msg);
	 				document.getElementById('deleteDocValidation').style.display = '';
	 				
	 				modalDeleteDocument.footerNode.insert(A.one ('#deleteDocValidation'));
	 				
	   				return false;	
	  			}
              
                         
            	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="deleteDocum"/></portlet:resourceURL>', 'json', 
				{ 
			   		documId: window.deleteDocId,
			   	  	deleteComment: comment
			 	},
				function( data )
				{
					document.getElementById('row_'+window.deleteDocId).style.display = 'none';
					window.deleteDocId = '';
					modalDeleteDocument.hide();
				} );
              }
          }
       }
	 ]);    
	 
	 

	 var modalSupportingDocsAll = new A.Modal({
		headerContent: '<h4><liferay-ui:message key="sup-docs-header" /></h4>',
        bodyContent: A.one("#supportingDocsAllDiv"),
        centered: true,
        destroyOnHide: false,
        modal: true,
        render: '#supportingDocsAllModal',
        resizable: {
          handles: 'b, r'
        },
        visible: false,
        width: 1050
    });

	 A.all('.supporting-documents-all').on('click', function( event ) {
  	 	//var id = event.currentTarget.attr('id');	 	   
		//console.log("assessment id from div is : "+ id);
		
   	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="vcgSupportingDocsAll"/></portlet:resourceURL>', 'html', 
			{ 
   	  			vcgId:'${vcg.vcgId}'
	 		},
			function( data )
			{
				overwrite( A.one( '#supportingDocsAllResult' ), data );
				modalSupportingDocsAll.render();
				modalSupportingDocsAll.show();
			}  		
		);
	});
	
	var modalDocHistory = new A.Modal({
		headerContent: '<h4><liferay-ui:message key="doc-audit-header" /></h4>',
        bodyContent: A.one("#docHistoryDiv"),
        centered: true,
        destroyOnHide: false,
        modal: true,
        render: '#docHistoryModal',
        resizable: {
          handles: 'b, r'
        },
        visible: false,
        width: 1000
    });
	
	 
	 A.all('.supporting-documents-history').on('click', function( event ) {
  		
   	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /><portlet:param name="page" value="vcgDocsHistoryAll"/></portlet:resourceURL>', 'html', 
			{ 
   	  			vcgId:'${vcg.vcgId}'
	 		},
			function( data )
			{
				overwrite( A.one( '#docHistoryResult' ), data );
				modalDocHistory.render();
				modalDocHistory.show();
			}  		
		);
	});
	 
	var sectionElement = document.getElementById("section");
	var sectionVal = sectionElement.value;
	
	if(sectionVal=='assessment'){
 	 	document.getElementById("ongoingAssessments").scrollIntoView(true);
 	}
	
	</aui:script>

	<div class="yui3-skin-sam">
		<div id="assmtValidationModal"></div>
	</div>
	
	<div id="assmtValidationDiv" class="yui3-skin-sam">	
		<div id="assmtValidationResult"></div>
	</div>
	
	<div class="yui3-skin-sam">
	   	<div id="assmtHistoryModal"></div>
	</div>
	
	<div id="assmtHistoryDiv" class="yui3-skin-sam">	
		<div id="assmtHistoryResult"></div>
	</div>

	<div class="yui3-skin-sam">
	   	<div id="periodicAssmtModal"></div>
	</div>
	
	<div id="periodicAssmtDiv" class="yui3-skin-sam">	
		<div id="periodicAssmtAllResult"></div>
	</div>
	
	<div class="yui3-skin-sam">
		<div id="deleteDocModal"></div>
	</div>
	
	<div id="deleteDocDiv" class="yui3-skin-sam" >	
		<aui:field-wrapper inlineField="true" cssClass="manage-layout-wide-input">
			<aui:input label="delete-doc-comment" name="delete_doc_comment" type="textarea" size="80" id="delete_doc_comment"/>
		</aui:field-wrapper>
		<br/>
		Do you want to proceed and delete the document?
			
		<div id="deleteDocValidation" style="display:none;"><br/></div>
	</div>
	
	<div class="yui3-skin-sam">
	   	<div id="supportingDocsAllModal"></div>
	</div>
	
	<div id="supportingDocsAllDiv" class="yui3-skin-sam">	
		<div id="supportingDocsAllResult"></div>
	</div>
	
	<div class="yui3-skin-sam">
	   	<div id="docHistoryModal"></div>
	</div>
	
	<div id="docHistoryDiv" class="yui3-skin-sam">	
		<div id="docHistoryResult"></div>
	</div>
	
<portlet:actionURL var="loadEntry">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadEntry"/>
	<portlet:param name="entry" value="MANAGE_VCG"/>
	<portlet:param name="vcgId" value="${vcg.vcgId}"/>
	<portlet:param name="section" value="assessment"/>
</portlet:actionURL>

<aui:form name="reload_fm" method="post"  action="${loadEntry}"></aui:form>	
	
		
<%@include file="/jsp/version.jsp" %>	
<%@include file="/jsp/im/compose.jsp" %>
	
